require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_CPUMASK_H)) {
    eval 'sub _SYS_CPUMASK_H () {1;}' unless defined(&_SYS_CPUMASK_H);
    # "$Revision: 1.12 $"
    if(defined(&_KERNEL) || defined(&_STANDALONE) || defined(&_KMEMUSER)) {
	if(((defined(&SN0) ? &SN0 : undef))) {
	    require 'sys/SN/SN0/arch.ph';
	}
	if(((defined(&SN1) ? &SN1 : undef))) {
	    require 'sys/SN/SN1/arch.ph';
	}
	unless(defined(&MAXCPUS)) {
	    if(defined(&MAXCPU)) {
		eval 'sub MAXCPUS () { &MAXCPU;}' unless defined(&MAXCPUS);
	    } else {
		eval 'sub MAXCPUS () {128;}' unless defined(&MAXCPUS);
	    }
	}
	if((defined(&LARGE_CPU_COUNT) ? &LARGE_CPU_COUNT : undef)) {
	    eval 'sub CPUMASK_SIZE () {( &MAXCPUS /  &_MIPS_SZLONG);}' unless defined(&CPUMASK_SIZE);
	    if((((defined(&_MIPS_SZLONG) ? &_MIPS_SZLONG : undef) == 32)  && ((defined(&CPUMASK_SIZE) ? &CPUMASK_SIZE : undef) < 2))) {
		die("macros\ currently\ only\ defined\ for\ 64\ bit\ kernels");
	    }
	    if(((defined(&MAXCPUS) ? &MAXCPUS : undef) <= 128) ) {
		eval 'sub CPUMASK_CLRALL {
		    my($p) = @_;
    		    eval q(($p). $_bits[0] = 0, ($p). $_bits[1] = 0);
		}' unless defined(&CPUMASK_CLRALL);
		eval 'sub CPUMASK_IS_ZERO {
		    my($p) = @_;
    		    eval q((($p). $_bits[0] == 0 && ($p). $_bits[1] == 0));
		}' unless defined(&CPUMASK_IS_ZERO);
		eval 'sub CPUMASK_IS_NONZERO {
		    my($p) = @_;
    		    eval q((($p). $_bits[0] != 0|| ($p). $_bits[1] != 0));
		}' unless defined(&CPUMASK_IS_NONZERO);
		eval 'sub CPUMASK_NOTEQ {
		    my($p, $q) = @_;
    		    eval q(((($p). $_bits[0] != ($q). $_bits[0]) || (($p). $_bits[1] != ($q). $_bits[1])));
		}' unless defined(&CPUMASK_NOTEQ);
		eval 'sub CPUMASK_SETM {
		    my($p, $q) = @_;
    		    eval q(($p). $_bits[0] |= ($q). $_bits[0], ($p). $_bits[1] |= ($q). $_bits[1]);
		}' unless defined(&CPUMASK_SETM);
		eval 'sub CPUMASK_CLRM {
		    my($p, $q) = @_;
    		    eval q(($p). $_bits[0] &= ~(($q). $_bits[0]), ($p). $_bits[1] &= ~(($q). $_bits[1]));
		}' unless defined(&CPUMASK_CLRM);
		eval 'sub CPUMASK_ANDM {
		    my($p, $q) = @_;
    		    eval q(($p). $_bits[0] &= (($q). $_bits[0]), ($p). $_bits[1] &= (($q). $_bits[1]));
		}' unless defined(&CPUMASK_ANDM);
		eval 'sub CPUMASK_TSTM {
		    my($p, $q) = @_;
    		    eval q(((($p). $_bits[0] & ($q). $_bits[0]) || (($p). $_bits[1] & ($q). $_bits[1])));
		}' unless defined(&CPUMASK_TSTM);
		eval 'sub CPUMASK_CPYNOTM {
		    my($p, $q) = @_;
    		    eval q(($p). $_bits[0] = ~(($q). $_bits[0]), ($p). $_bits[1] = ~(($q). $_bits[1]));
		}' unless defined(&CPUMASK_CPYNOTM);
		eval 'sub CPUMASK_ORNOTM {
		    my($p, $q) = @_;
    		    eval q(($p). $_bits[0] |= ~(($q). $_bits[0]), ($p). $_bits[1] |= ~(($q). $_bits[1]));
		}' unless defined(&CPUMASK_ORNOTM);
		eval 'sub CPUMASK_COPY {
		    my($p, $q) = @_;
    		    eval q(($p). $_bits[0] = (($q). $_bits[0]), ($p). $_bits[1] = (($q). $_bits[1]));
		}' unless defined(&CPUMASK_COPY);
		eval 'sub CPUMASK_ATOMSET {
		    my($p, $q) = @_;
    		    eval q({  &ASSERT(!($q). $_bits[0] || !($q). $_bits[1]);  &if (($q). $_bits[0])  &atomicSetCpumask(( &cpumask_t *)($p). $_bits[0], ( &cpumask_t *)($q). $_bits[0]);  &else  &atomicSetCpumask(( &cpumask_t *)($p). $_bits[1], ( &cpumask_t *)($q). $_bits[1]); });
		}' unless defined(&CPUMASK_ATOMSET);
		eval 'sub CPUMASK_ATOMCLR {
		    my($p, $q) = @_;
    		    eval q({  &ASSERT(!($q). $_bits[0] || !($q). $_bits[1]);  &if (($q). $_bits[0])  &atomicClearCpumask(( &cpumask_t *)($p). $_bits[0], ( &cpumask_t *)($q). $_bits[0]);  &else  &atomicClearCpumask(( &cpumask_t *)($p). $_bits[1], ( &cpumask_t *)($q). $_bits[1]); });
		}' unless defined(&CPUMASK_ATOMCLR);
	    } else {
		if(((defined(&_MIPS_SZLONG) ? &_MIPS_SZLONG : undef) != 32)) {
		    eval 'sub CPUMASK_CLRALL {
		        my($p) = @_;
    			eval q({ \'int\'  &_i;  &for ( &_i = 0;  &_i <  &CPUMASK_SIZE ;  &_i++) ($p). $_bits[ &_i] = 0; });
		    }' unless defined(&CPUMASK_CLRALL);
		    eval 'sub CPUMASK_SETM {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &_i;  &for ( &_i = 0;  &_i <  &CPUMASK_SIZE ;  &_i++) ($p). $_bits[ &_i] |= (($q). $_bits[ &_i]); });
		    }' unless defined(&CPUMASK_SETM);
		    eval 'sub CPUMASK_CLRM {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &_i;  &for ( &_i = 0;  &_i <  &CPUMASK_SIZE ;  &_i++) ($p). $_bits[ &_i] &= ~(($q). $_bits[ &_i]); });
		    }' unless defined(&CPUMASK_CLRM);
		    eval 'sub CPUMASK_ANDM {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &_i;  &for ( &_i = 0;  &_i <  &CPUMASK_SIZE ;  &_i++) ($p). $_bits[ &_i] &= (($q). $_bits[ &_i]); });
		    }' unless defined(&CPUMASK_ANDM);
		    eval 'sub CPUMASK_CPYNOTM {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &_i;  &for ( &_i = 0;  &_i <  &CPUMASK_SIZE ;  &_i++) ($p). $_bits[ &_i] = ~(($q). $_bits[ &_i]); });
		    }' unless defined(&CPUMASK_CPYNOTM);
		    eval 'sub CPUMASK_ORNOTM {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &_i;  &for ( &_i = 0;  &_i <  &CPUMASK_SIZE ;  &_i++) ($p). $_bits[ &_i] |= ~(($q). $_bits[ &_i]); });
		    }' unless defined(&CPUMASK_ORNOTM);
		    eval 'sub CPUMASK_COPY {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &_i;  &for ( &_i = 0;  &_i <  &CPUMASK_SIZE ;  &_i++) ($p). $_bits[ &_i] = (($q). $_bits[ &_i]); });
		    }' unless defined(&CPUMASK_COPY);
		    eval 'sub CPUMASK_ATOMSET {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &_i;  &for ( &_i = 0;  &_i <  &CPUMASK_SIZE ;  &_i++) {  &if (($q). $_bits[ &_i]) {  &atomicSetCpumask(( &cpumask_t *)($p). $_bits[ &_i], ( &cpumask_t *)($q). $_bits[ &_i]);  &break; } } });
		    }' unless defined(&CPUMASK_ATOMSET);
		    eval 'sub CPUMASK_ATOMCLR {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &_i;  &for ( &_i = 0;  &_i <  &CPUMASK_SIZE ;  &_i++) {  &if (($q). $_bits[ &_i]) {  &atomicClearCpumask(( &cpumask_t *)($p). $_bits[ &_i], ( &cpumask_t *)($q). $_bits[ &_i]);  &break; } } });
		    }' unless defined(&CPUMASK_ATOMCLR);
		    eval 'sub CPUMASK_IS_NONZERO {
		        my($p) = @_;
    			eval q({ \'int\'  &i;  &for ( &i = 0;  &i <  &CPUMASK_SIZE ;  &i++)  &if ( ($p->{_bits[&i]}) != 0) 1; 0; });
		    }' unless defined(&CPUMASK_IS_NONZERO);
		    eval 'sub CPUMASK_NOTEQ {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &i;  &for ( &i = 0;  &i <  &CPUMASK_SIZE ;  &i++)  &if ( ($p->{_bits[&i]}) !=  ($q->{_bits[&i]})) 1; 0; });
		    }' unless defined(&CPUMASK_NOTEQ);
		    eval 'sub CPUMASK_TSTM {
		        my($p,$q) = @_;
    			eval q({ \'int\'  &i;  &for ( &i = 0;  &i <  &CPUMASK_SIZE ;  &i++)  &if ( ($p->{_bits[&i]}) &  ($q->{_bits[&i]})) 1; 0; });
		    }' unless defined(&CPUMASK_TSTM);
		}
	    }
	    if((defined(&TFP) ? &TFP : undef)) {
		eval 'sub CPUMASK_SETB {
		    my($p, $bit) = @_;
    		    eval q({  &if ( &CPUMASK_INDEX($bit)) ($p). $_bits[1] |= (1 <<  &CPUMASK_SHFT($bit));  &else ($p). $_bits[0] |= (1 <<  &CPUMASK_SHFT($bit));});
		}' unless defined(&CPUMASK_SETB);
		eval 'sub CPUMASK_CLRB {
		    my($p, $bit) = @_;
    		    eval q({  &if ( &CPUMASK_INDEX($bit)) ($p). $_bits[1] &= ~(1 <<  &CPUMASK_SHFT($bit));  &else ($p). $_bits[0] &= ~(1 <<  &CPUMASK_SHFT($bit));});
		}' unless defined(&CPUMASK_CLRB);
		eval 'sub CPUMASK_TSTB {
		    my($p, $bit) = @_;
    		    eval q(( &CPUMASK_INDEX($bit) ? ($p). $_bits[1] & (1 <<  &CPUMASK_SHFT($bit)) : ($p). $_bits[0] & (1 <<  &CPUMASK_SHFT($bit))));
		}' unless defined(&CPUMASK_TSTB);
	    } else {
		eval 'sub CPUMASK_SETB {
		    my($p, $bit) = @_;
    		    eval q(($p). $_bits[ &CPUMASK_INDEX($bit)] |= (1 <<  &CPUMASK_SHFT($bit)));
		}' unless defined(&CPUMASK_SETB);
		eval 'sub CPUMASK_CLRB {
		    my($p, $bit) = @_;
    		    eval q(($p). $_bits[ &CPUMASK_INDEX($bit)] &= ~(1 <<  &CPUMASK_SHFT($bit)));
		}' unless defined(&CPUMASK_CLRB);
		eval 'sub CPUMASK_TSTB {
		    my($p, $bit) = @_;
    		    eval q((($p). $_bits[ &CPUMASK_INDEX($bit)] & (1 <<  &CPUMASK_SHFT($bit))));
		}' unless defined(&CPUMASK_TSTB);
	    }
	    eval 'sub CPUMASK_INDEX {
	        my($bit) = @_;
    		eval q((($bit) >> 6));
	    }' unless defined(&CPUMASK_INDEX);
	    eval 'sub CPUMASK_SHFT {
	        my($bit) = @_;
    		eval q((($bit) & 0x3f));
	    }' unless defined(&CPUMASK_SHFT);
	    eval 'sub CPUMASK_ATOMTSTSETB {
	        my($p, $bit) = @_;
    		eval q(( &atomicSetUint64(($p). $_bits[ &CPUMASK_INDEX($bit)], (1<< &CPUMASK_SHFT($bit))) & (1<< &CPUMASK_SHFT($bit))));
	    }' unless defined(&CPUMASK_ATOMTSTSETB);
	    eval 'sub CPUMASK_ATOMTSTCLRB {
	        my($p, $bit) = @_;
    		eval q(( &atomicClearUint64(($p). $_bits[ &CPUMASK_INDEX($bit)], (1<< &CPUMASK_SHFT($bit))) & (1<< &CPUMASK_SHFT($bit))));
	    }' unless defined(&CPUMASK_ATOMTSTCLRB);
	    eval 'sub CPUMASK_ATOMSETB {
	        my($p, $bit) = @_;
    		eval q( &atomicSetUint64(($p). $_bits[ &CPUMASK_INDEX($bit)], (1<< &CPUMASK_SHFT($bit))));
	    }' unless defined(&CPUMASK_ATOMSETB);
	    eval 'sub CPUMASK_ATOMCLRB {
	        my($p, $bit) = @_;
    		eval q( &atomicClearUint64(($p). $_bits[ &CPUMASK_INDEX($bit)], (1<< &CPUMASK_SHFT($bit))));
	    }' unless defined(&CPUMASK_ATOMCLRB);
	} else {
	    if(defined(&EVEREST)) {
		eval 'sub CPUMASK_SETB {
		    my($p, $bit) = @_;
    		    eval q(($p) |= 1 << ($bit));
		}' unless defined(&CPUMASK_SETB);
		eval 'sub CPUMASK_CLRB {
		    my($p, $bit) = @_;
    		    eval q(($p) &= ~(1 << ($bit)));
		}' unless defined(&CPUMASK_CLRB);
		eval 'sub CPUMASK_TSTB {
		    my($p, $bit) = @_;
    		    eval q((($p) & (1 << ($bit))));
		}' unless defined(&CPUMASK_TSTB);
		eval 'sub CPUMASK_ATOMTSTSETB {
		    my($p, $bit) = @_;
    		    eval q(( &atomicSetUint64(($p), (1<<($bit))) & (1<<($bit))));
		}' unless defined(&CPUMASK_ATOMTSTSETB);
		eval 'sub CPUMASK_ATOMTSTCLRB {
		    my($p, $bit) = @_;
    		    eval q(( &atomicClearUint64(($p), (1<<($bit)) & (1<<($bit)))));
		}' unless defined(&CPUMASK_ATOMTSTCLRB);
		eval 'sub CPUMASK_ATOMSETB {
		    my($p, $bit) = @_;
    		    eval q( &atomicSetUint64(($p), (1<<($bit))));
		}' unless defined(&CPUMASK_ATOMSETB);
		eval 'sub CPUMASK_ATOMCLRB {
		    my($p, $bit) = @_;
    		    eval q( &atomicClearUint64(($p), (1<<($bit))));
		}' unless defined(&CPUMASK_ATOMCLRB);
	    } else {
		eval 'sub CPUMASK_SETB {
		    my($p, $bit) = @_;
    		    eval q(($p) |= 1<< ($bit));
		}' unless defined(&CPUMASK_SETB);
		eval 'sub CPUMASK_CLRB {
		    my($p, $bit) = @_;
    		    eval q(($p) &= ~(1<< ($bit)));
		}' unless defined(&CPUMASK_CLRB);
		eval 'sub CPUMASK_TSTB {
		    my($p, $bit) = @_;
    		    eval q((($p) & (1<< ($bit))));
		}' unless defined(&CPUMASK_TSTB);
		eval 'sub CPUMASK_ATOMTSTSETB {
		    my($p, $bit) = @_;
    		    eval q(( &atomicSetUint(($p), (1<<($bit))) & (1<<($bit))));
		}' unless defined(&CPUMASK_ATOMTSTSETB);
		eval 'sub CPUMASK_ATOMTSTCLRB {
		    my($p, $bit) = @_;
    		    eval q(( &atomicClearUint(($p), (1<<($bit))) & (1<<($bit))));
		}' unless defined(&CPUMASK_ATOMTSTCLRB);
		eval 'sub CPUMASK_ATOMSETB {
		    my($p, $bit) = @_;
    		    eval q( &atomicSetUint(($p), (1<<($bit))));
		}' unless defined(&CPUMASK_ATOMSETB);
		eval 'sub CPUMASK_ATOMCLRB {
		    my($p, $bit) = @_;
    		    eval q( &atomicClearUint(($p), (1<<($bit))));
		}' unless defined(&CPUMASK_ATOMCLRB);
	    }
	    eval 'sub CPUMASK_CLRALL {
	        my($p) = @_;
    		eval q(($p) = 0);
	    }' unless defined(&CPUMASK_CLRALL);
	    eval 'sub CPUMASK_IS_ZERO {
	        my($p) = @_;
    		eval q((($p) == 0));
	    }' unless defined(&CPUMASK_IS_ZERO);
	    eval 'sub CPUMASK_IS_NONZERO {
	        my($p) = @_;
    		eval q((($p) != 0));
	    }' unless defined(&CPUMASK_IS_NONZERO);
	    eval 'sub CPUMASK_NOTEQ {
	        my($p, $q) = @_;
    		eval q((($p) != ($q)));
	    }' unless defined(&CPUMASK_NOTEQ);
	    eval 'sub CPUMASK_SETM {
	        my($p, $q) = @_;
    		eval q(($p) |= ($q));
	    }' unless defined(&CPUMASK_SETM);
	    eval 'sub CPUMASK_CLRM {
	        my($p, $q) = @_;
    		eval q(($p) &= ~($q));
	    }' unless defined(&CPUMASK_CLRM);
	    eval 'sub CPUMASK_ANDM {
	        my($p, $q) = @_;
    		eval q(($p) &= ($q));
	    }' unless defined(&CPUMASK_ANDM);
	    eval 'sub CPUMASK_TSTM {
	        my($p, $q) = @_;
    		eval q((($p) & ($q)));
	    }' unless defined(&CPUMASK_TSTM);
	    eval 'sub CPUMASK_CPYNOTM {
	        my($p, $q) = @_;
    		eval q(($p) = ~($q));
	    }' unless defined(&CPUMASK_CPYNOTM);
	    eval 'sub CPUMASK_ORNOTM {
	        my($p, $q) = @_;
    		eval q(($p) |= ~($q));
	    }' unless defined(&CPUMASK_ORNOTM);
	    eval 'sub CPUMASK_ATOMSET {
	        my($p, $q) = @_;
    		eval q( &atomicSetCpumask(( &cpumask_t *)($p), ( &cpumask_t *)($q)));
	    }' unless defined(&CPUMASK_ATOMSET);
	    eval 'sub CPUMASK_ATOMCLR {
	        my($p, $q) = @_;
    		eval q( &atomicClearCpumask(( &cpumask_t *)($p), ( &cpumask_t *)($q)));
	    }' unless defined(&CPUMASK_ATOMCLR);
	}
    }
}
1;
