#!/usr/sgug/bin/sh

[ $# -ge 2 ] || {
    cat > /dev/null
    exit 0
}

case $1 in
-P|--provides)
    shift
    RPM_BUILD_ROOT="$1"
    while read possible
    do
	case "$possible" in
	*.la)
	    if grep -Eiq '^# Generated by (libtool|ltmain.sh)' "$possible" 2> /dev/null ; then
		possible="`echo ${possible} | sed -e s,${RPM_BUILD_ROOT}/,/,`"
		echo "libtool($possible)"
	    fi
	    ;;
	esac
    done
    ;;
-R|--requires)
    while read possible ; do
	case "$possible" in
	*.la)
	    for dep in `grep '^dependency_libs='"$possible" 2> /dev/null | \
			sed -e "s,^dependency_libs='\(.*\)',\1,g"`
	    do
		case "$dep" in
		/*.la)
		    echo "libtool($dep)"
		    ;;
		esac
	    done
	    ;;
	esac
    done
    ;;
esac
exit 0
